// next.c

#include "main.h"
#include "next.h"
#include "wdef.h"
#include "graphics.h"
#include "gworld.h"
#include "gameticks.h"
#include "random.h"
#include "blitter.h"
#include "level.h"

#define kJiggleFrames 8
#define kPulling 10
#define kPullingFrames 18

Rect nextWindowZRect, nextWindowRect[2];
Boolean nextWindowVisible[2] = {true, true};
GWorldPtr nextWorld, nextDrawWorld;
int nextTime[2][2], nextStage[2][2], pullA[2], pullB[2];

void InitNext( void )
{
	const double windowLoc[] = {0.46, 0.54};

	nextWindowZRect.top = nextWindowZRect.left = 0;
	nextWindowZRect.bottom = 72; nextWindowZRect.right = 32;
	
	nextWindowRect[0] = nextWindowRect[1] = nextWindowZRect;
	CenterRectInPort( &nextWindowRect[0], backdropPort, windowLoc[0], 0.25 );
	CenterRectInPort( &nextWindowRect[1], backdropPort, windowLoc[1], 0.25 );	
	
	InitGWorld( &nextWorld, &nextWindowZRect, 16 );
	DrawPictInGWorld( nextWorld, picNext );

	InitGWorld( &nextDrawWorld, &nextWindowZRect, 16 );
}

void RefreshNext( int player )
{
	nextStage[player][0] = 0;
    nextStage[player][1] = 0;

	nextTime[player][0] = GameTickCount( ) + RandomBefore( 60 );
	nextTime[player][1] = GameTickCount( ) + RandomBefore( 60 );

	ShowNext( player );
}

void PullNext( int player )
{
	pullA[player] = nextA[player];
	pullB[player] = nextB[player];
	nextStage[player][0] = kPulling;
	nextTime[player][0] = GameTickCount( );
}

#define kNoDraw 999
void ShowPull( int player )
{
	Rect srcRect;
	int yank[8] = { 20, 18, 15, 8, -6, -26, -46, -66 };
	int slide[8] = { kNoDraw, 66, 48, 36, 29, 26, 24, 23 };
	int drawA, drawB, offset, count;
	
	if( !nextWindowVisible[player] ) return;
	
	PrepareForGDrawing( nextDrawWorld );
	
	CopyBits( GetPortBitMapForCopyBits(nextWorld), GetPortBitMapForCopyBits(nextDrawWorld),
			  &nextWindowZRect, &nextWindowZRect,
			  srcCopy, nil );
	
	for( count=0; count<2; count++ )
	{
		offset = nextStage[player][0] - kPulling;
		
		switch( count )
		{
			case 0: drawA = pullA[player]; drawB = pullB[player]; offset = yank[offset];  break;
			case 1: drawA = nextA[player]; drawB = nextB[player]; offset = slide[offset]; break;
		}
		
		if( offset != kNoDraw )
		{
			Rect blobRect = { 0, 4, 0 + kBlobVertSize, 4 + kBlobHorizSize };
			Rect shadowRect = { 4, 8, 4 + kBlobVertSize, 8 + kBlobHorizSize };

			OffsetRect( &blobRect, 0, offset );
			OffsetRect( &shadowRect, 0, offset );
					
			DrawShadow( &shadowRect, drawB, kNoSuction );
			
			CalcBlobRect( kNoSuction, drawB-1, &srcRect );
			BlitBlobMask( &srcRect, &blobRect );	  
					  
			OffsetRect( &blobRect, 0, kBlobVertSize );
			OffsetRect( &shadowRect, 0, kBlobVertSize );
			
			DrawShadow( &shadowRect, drawA, nextM[player]? kFlashDarkBlob: kNoSuction );

			CalcBlobRect( nextM[player]? kFlashDarkBlob: kNoSuction, drawA-1, &srcRect );
			BlitBlobMask( &srcRect, &blobRect );	  
		}
	}
	
	FinishGDrawing( nextDrawWorld );

	SetPort( backdropPort );
	CopyBits( GetPortBitMapForCopyBits(nextDrawWorld), 
			  GetPortBitMapForCopyBits(backdropPort),
			  &nextWindowZRect, &nextWindowRect[player], srcCopy, nil );
}

void UpdateNext( int player )
{
	Boolean changed = false;
	int blob;
	
	if( nextStage[player][0] >= kPulling )
	{
		if( GameTickCount() > nextTime[player][0] )
		{
			if( ++nextStage[player][0] >= kPullingFrames )
			{
				RefreshNext( player );
			}
			else
			{
				ShowPull( player );
				nextTime[player][0]++;
			}
		}
	} 
	else
	{
		for( blob=0; blob<2; blob++ )
		{	
			if( GameTickCount() > nextTime[player][blob] )
			{
				if( ++nextStage[player][blob] >= kJiggleFrames )
				{
					nextStage[player][blob] = 0;
					nextTime[player][blob] += 40 + RandomBefore( 80 );
				}
				else
				{
					nextTime[player][blob] += 2;
				}
					
				changed = true;
			}
		}
		
		if( changed ) ShowNext( player );
	}
}

void ShowNext( int player )
{
	int jiggle[kJiggleFrames] = { kNoSuction,  kSquish,  kNoSuction,  kSquash,    
	                              kNoSuction,  kSquish,  kNoSuction,  kSquash   };
	int nextFrame = kNoSuction;
	Rect blobRect = { 22, 4, 22 + kBlobVertSize, 4 + kBlobHorizSize };
	Rect shadowRect = { 26, 8, 26 + kBlobVertSize, 8 + kBlobHorizSize };
	Rect srcRect;
	
	if( !nextWindowVisible[player] ) return;

	if( control[player] == kNobodyControl )
	{
	}
	else
	{
		PrepareForGDrawing( nextDrawWorld );
		
		CopyBits( GetPortBitMapForCopyBits(nextWorld), GetPortBitMapForCopyBits(nextDrawWorld),
				  &nextWindowZRect, &nextWindowZRect, srcCopy, nil );
		
		nextFrame = nextG[player]? kNoSuction: jiggle[nextStage[player][0]];
		
		DrawShadow( &shadowRect, nextB[player], nextFrame );
		
		CalcBlobRect( nextFrame, nextB[player]-1, &srcRect );
		BlitBlobMask( &srcRect, &blobRect );	  
				  
		OffsetRect( &blobRect, 0, kBlobVertSize );
		OffsetRect( &shadowRect, 0, kBlobVertSize );

		nextFrame = nextG[player]? kNoSuction: 
						(nextM[player]? kFlashDarkBlob: jiggle[nextStage[player][1]]);
		
		DrawShadow( &shadowRect, nextA[player], nextFrame );

		CalcBlobRect( nextFrame, nextA[player]-1, &srcRect );
		BlitBlobMask( &srcRect, &blobRect );	  
		
		FinishGDrawing( nextDrawWorld );

		SetPort( backdropPort );
		CopyBits( GetPortBitMapForCopyBits(nextDrawWorld), 
				  GetPortBitMapForCopyBits(backdropPort),
				  &nextWindowZRect, &nextWindowRect[player], srcCopy, nil );
	}
}
